using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class AquariumEastAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new AquariumEastAddonDeed();
			}
		}

		[ Constructable ]
		public AquariumEastAddon()
		{
			AddComponent( new AddonComponent( 12384 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 12385 ), 0, 0, 0 );
// 			AddonComponent ac = null;
		}

		public AquariumEastAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class AquariumEastAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new AquariumEastAddon();
			}
		}

		[Constructable]
		public AquariumEastAddonDeed()
		{
			Name = "An Aquarium";
		}

		public AquariumEastAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}